#include "STM32.h"

int main(void)
{
  uint16_t Temp1, Temp2, Temp3, Temp4;

  SystemClock_Config(Quartz_8);

  Temp1 = millis();
  delay(10);
  Temp2 = millis();

  Temp3 = micros();
  delayMicroseconds(10);
  Temp4 = micros();

  /*
   * Следующий код позволит на выводе PA8 посмотреть тактовую частоту ядра делённую на 4
   * То есть 42МГц. Если найдёте осцилограф, котрый сможет это показать
   */
  _SetSpeed(Speed_WeryHigh);                                // Будем настраивать порт на самую высокую частоту какая возможна
  _SetPinAlternate(GPIOA, GPIO_PIN_8, GPIO_AF0_MCO);        // Инициализирум порт для вывода альтернативной функции "Вывод тактовой частоты через MCO1 на вывод порта

  RCC->CFGR |= (0b110 << RCC_CFGR_MCO1PRE_Pos);             // Включаем деление на 4
  RCC->CFGR |= (0b11 << RCC_CFGR_MCO1_Pos);                 // Источником сигнала будет выход PLL

  while (1)
  {
  }
}

void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
//  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

